* TCP ROUTINES FOR MARINA - 13 APR 15
*
TCPLEN DS 2 ; LENGTH OF TCP HEAD + BODY
TCPHEADLEN DS 2 ; LENGTH OF TCP HEAD
*
*
* THIS IS THE INCOMING TCP SEGMENT HANDLER. SEE RFC 793,
* PAGES 65 TO 76 FOR THE ALGORITHM
*
HANDLETCP
*
* COMPUTE TCP LENGTH
*
 SEC
 LDY #3 ; LOW BYTE OF IP LENGTH
 LDA (INPBUF),Y
 SBC IPHEADLEN
 STA TCPLEN
 DEY
 LDA (INPBUF),Y ; HIGH BYTE
 SBC #0
 STA TCPLEN+1
*
* GET LENGTH OF TCP HEADER
*
* THE VALUE GIVEN IS IN 32 BIT WORDS, SO WE NEED TO SHIFT
* IT RIGHT TWO TIMES TO GET THE 8 BIT VALUE.
*
* WE CAN'T ADVANCE INPBUF YET BECAUSE IT NEEDS TO POINT
* TO THE IP HEADER FOR CHECKSUM COMPUTATION.
*
 CLC
 LDA IPHEADLEN
 ADC #12 ; POINT TO HEADER LENGTH
 TAY
 LDA (INPBUF),Y
 AND #%11110000 ; MASK OUT LOW 4 BITS
 LSR
 LSR
*
* VERIFY THE LENGTH (OFFSET)
* THIS CHECKS THAT THE OFFSET ISN'T TOO
* SMALL. ANOTHER CHECK WE COULD DO IS TO ENSURE
* IT ISN'T GREATER THAN THE TOTAL IP LENGTH.
*
 CMP #20 ; MINIMUM LENGTH
 BCS :STORELEN ; OK
 JMP :DONE ; DROP THIS
:STORELEN
 STA TCPHEADLEN
*
* COMPUTE PAYLOAD LENGTH FOR CHECKSUM
*
 SEC
 LDA TCPLEN
 SBC TCPHEADLEN
 STA CHKSUMLEN
 LDA TCPLEN+1
 SBC #0
 STA CHKSUMLEN+1
*
* VERIFY TCP CHECKSUM
* SETUP PTR AND PTR2 FOR IP HEAD AND TCP DATA PAYLOAD
*
 CLC
 LDA INPBUF
 STA PTR
 ADC IPHEADLEN
 STA PTR2
 LDA INPBUF+1
 STA PTR+1
 ADC #0
 STA PTR2+1
* MOVE PTR2 TCPHEADLEN BYTES TO POINT AT DATA PAYLOAD
 CLC
 LDA PTR2
 ADC TCPHEADLEN
 STA PTR2
 LDA PTR2+1
 ADC #0
 STA PTR2+1
 JSR TCPCHKSUM
 ORA CHKSUM+1
 BNE :BADCHKSUM
*
* CHECKSUM OK
*
 DO DEBUG
 LDA #"+"
 JSR COUT
 FIN
 JMP :INCP
*
* CHECKSUM BAD
*
:BADCHKSUM
 DO DEBUG
 LDA #" "
 JSR COUT
 LDA CHKSUM+1
 LDX CHKSUM
 JSR PRNTAX
 LDA #"@"
 JSR COUT
 FIN
 SEC
 RTS
*
* PROCESS TCP HEADER
*
:INCP
 CLC
 LDA INPBUF ; ADVANCE THE POINTER
 ADC IPHEADLEN ; ...TO THE TCP DATA
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
*
* PRINT SEGMENT TYPE (DEBUG)
*
 DO DEBUG
 LDY #13 ; POINT TO CONTROL BITS
 LDA (INPBUF),Y
 AND #%00000010 ; SYN FLAG
 BEQ :DEBUGNEXT
 LDA #" "
 JSR COUT
 LDA #"S"
 JSR COUT
 LDA #"Y"
 JSR COUT
 LDA #"N"
 JSR COUT
:DEBUGNEXT
 FIN
*
* MATCH THIS INCOMING SEGMENT TO AN OPEN SOCKET
* IF THERE'S NO SOCKET, SEND A RESET BACK TO THE HOST.
*
 JSR SOGETTCPSOBY
 BCC :SOCKFOUND
*
* SOCKET NOT FOUND
*
 DO DEBUG
 LDA #"*"
 JSR COUT
 FIN
 LDA INPBUF
 STA PTR
 LDA INPBUF+1
 STA PTR+1
 JSR TCPSENDRESET
 RTS
*
* SOCKET WAS FOUND. NOW THE REAL WORK BEGINS.
*
:SOCKFOUND
 DO DEBUG
 PHA ; SAVE SOCKET ID
 JSR PRBYTE
 LDA #"$"
 JSR COUT
 FIN
:DONE RTS
*
*
*
* COMPUTE TCP CHECKSUM
* THIS IS SIMILAR TO UDPCHKSUM AND USES AN ENTRY POINT
* IN IT. THERE ARE TWO POINTERS: PTR TO HEAD, AND PTR2
* TO DATA PAYLOAD. RESULT IS STORED IN CHKSUM.
*
* STORE LENGTH OF IP HEADER IN IPHEADLEN
* STORE LENGTH OF TCP HEADER IN TCPHEADLEN
* STORE LENGTH OF TCP HEAD + BODY IN TCPLEN
* STORE LENGTH OF DATA PAYLOAD IN CHKSUMLEN
*
* THE TCP CHECKSUM ALSO COVERS A 12-BYTE PSEUDO HEADER
*
TCPCHKSUM
 LDA #0
 STA CHKSUM ; ZERO OUT CHECKSUM
 STA CHKSUM+1
 CLC
* SUM THE PSEUDO HEADER
 LDY #12 ; OFFSET TO SOURCE ADDRESS
 LDX #7 ; COUNT DOWN
:L LDA (PTR),Y
 ADC CHKSUM
 STA CHKSUM
 INY
 DEX
 LDA (PTR),Y
 ADC CHKSUM+1
 STA CHKSUM+1
 INY
 DEX
 BPL :L
* ZERO
 LDA #0
 ADC CHKSUM
 STA CHKSUM
* PROTOCOL
 LDY #9 ; OFFSET TO PROTOCOL
 LDA (PTR),Y
 ADC CHKSUM+1
 STA CHKSUM+1
* TCP LENGTH: THIS IS THE HEADER PLUS DATA LENGTH.
* IT IS EQUAL TO THE TOTAL IP DATAGRAM LENGTH MINUS
* THE IP HEADER LENGTH.
 LDA TCPLEN+1 ; MUST ADD HIGH BYTE FIRST
 ADC CHKSUM
 STA CHKSUM
 LDA TCPLEN
 ADC CHKSUM+1
 STA CHKSUM+1
* NOW SUM THE TCP HEADER
 LDY IPHEADLEN ; OFFSET TO TCP HEAD
 LDX TCPHEADLEN ; COUNT DOWN TO AVOID CPX
 DEX
:L2 LDA (PTR),Y
 ADC CHKSUM
 STA CHKSUM
 DEX
 INY
 LDA (PTR),Y
 ADC CHKSUM+1
 STA CHKSUM+1
 INY
 DEX
 BPL :L2
* NOW SUM THE DATA. THIS IS WHERE WE SWITCH TO PTR2.
 JMP UDPCHKSUM2
*
* RETURNS WITH LOW BYTE OF CHKSUM IN A-REG.
*
